/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PICageInfoDataBean;
import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCSysProfClient;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PISysProfDataBean;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;

public class PISystemConfigurationList {
    private static final int NUM_VALID_PARMS = 9;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_format;
    private boolean m_header;
    private String m_filter;
    private String m_frame;
    private HashMap m_validParms = new HashMap(19, 0.5f);
    private String[] m_filterPartNames = null;
    private String[] m_filterPartIDs = null;
    private String[] m_filterProfs = null;
    private String[] m_filterCluster = null;
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private String m_theHostName = null;
    private String m_delimiter = ",";
    private PrintStream m_outStream;
    private boolean m_writeStatus;

    private PISystemConfigurationList(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_FrameClient = pIHSCFrameClient;
        this.m_outStream = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("--filter", null);
        this.m_validParms.put("-n", null);
        this.m_validParms.put("--all", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("-e", null);
    }

    private void doFrameList() throws PIHscClientException {
        if (this.m_frame != null) {
            this.doSingleFrameList(this.m_FrameClient);
        } else {
            try {
                Enumeration enumeration = null;
                enumeration = PIHscUtil.getCIMEnumInstances(this.m_theHostName, new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0"), true, false);
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    this.doSingleFrameList(null);
                } else {
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        Object var2_3 = null;
                        CIMInstance cIMInstance = null;
                        cIMInstance = (CIMInstance)enumeration.nextElement();
                        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
                        PIHSCFrameClient pIHSCFrameClient = this.m_factory.createFrameClient(string, false);
                        if (pIHSCFrameClient == null) continue;
                        this.doSingleFrameList(pIHSCFrameClient);
                    }
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
    }

    private void doCageList() throws PIHscClientException {
        if (this.m_frame != null) {
            String[] stringArray;
            String[] stringArray2 = new String[]{"cage_num", "contents", "type_model_serial_num", "loc_code", "owner"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            Vector<PICageInfoDataBean> vector = new Vector<PICageInfoDataBean>();
            PICageInfoDataBean[] pICageInfoDataBeanArray = this.m_FrameClient.getFrameCageInfo();
            for (int i = 0; i < pICageInfoDataBeanArray.length; ++i) {
                vector.addElement(pICageInfoDataBeanArray[i]);
            }
            PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
            this.m_writeStatus = false;
        }
    }

    private void doSystemList() throws PIHscClientException {
        if (this.m_managedSystem != null) {
            this.doSingleSystemList(this.m_CECClient);
        } else {
            try {
                Enumeration enumeration = null;
                enumeration = PIHscUtil.getCIMEnumInstances(this.m_theHostName, new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0"), true, false);
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    this.doSingleSystemList(null);
                } else {
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        Object var2_3 = null;
                        CIMInstance cIMInstance = null;
                        cIMInstance = (CIMInstance)enumeration.nextElement();
                        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
                        PIHSCCECClient pIHSCCECClient = this.m_factory.createCECClient(string, true);
                        if (pIHSCCECClient == null) continue;
                        this.doSingleSystemList(pIHSCCECClient);
                    }
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
    }

    private void doSingleFrameList(PIHSCFrameClient pIHSCFrameClient) throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"name", "frame_num", "type_model", "serial_num", "state", "ipaddr_a", "ipaddr_b", "curr_power_on_side_a", "pend_power_on_side_a", "curr_power_on_side_b", "pend_power_on_side_b"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<PIFrameDataBean> vector = new Vector<PIFrameDataBean>();
        if (pIHSCFrameClient != null) {
            PIFrameDataBean pIFrameDataBean = pIHSCFrameClient.getFrameDataBean(stringArray);
            vector.addElement(pIFrameDataBean);
        }
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        this.m_writeStatus = false;
    }

    private void doSingleSystemList(PIHSCCECClient pIHSCCECClient) throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = new String[]{"name", "type_model", "serial_num", "ipaddr", "state", "sys_time", "power_off_policy", "cod_mem_capable", "cod_proc_capable", "micro_lpar_capable", "os400_capable", "vet_activation_capable", "virtual_io_server_capable", "assign_5250_cpw_percent", "max_lpars", "max_power_ctrl_lpars", "service_lpar_id", "service_lpar_name", "curr_sys_keylock", "pend_sys_keylock", "curr_power_on_side", "pend_power_on_side", "curr_power_on_speed", "pend_power_on_speed", "curr_power_on_speed_override", "pend_power_on_speed_override", "power_on_type", "power_on_option", "power_on_method", "power_on_attr", "sp_boot_attr", "sp_boot_major_type", "sp_boot_minor_type", "sp_version", "mfg_default_config", "curr_mfg_default_ipl_source", "pend_mfg_default_ipl_source", "curr_mfg_default_boot_mode", "pend_mfg_default_boot_mode"};
        String[] stringArray4 = new String[]{"mm_type_model", "mm_serial_num", "mm_ww_node_num", "mm_server_num", "mm_mfg_date"};
        String[] stringArray5 = new String[]{"shared_proc_capable"};
        if (this.m_format != null && this.m_format.length() > 0) {
            stringArray2 = new String[stringArray3.length + stringArray4.length + stringArray5.length];
            System.arraycopy(stringArray3, 0, stringArray2, 0, stringArray3.length);
            System.arraycopy(stringArray4, 0, stringArray2, stringArray3.length, stringArray4.length);
            System.arraycopy(stringArray5, 0, stringArray2, stringArray3.length + stringArray4.length, stringArray5.length);
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray3;
        }
        stringArray2 = new Vector();
        if (pIHSCCECClient != null) {
            PICECDataBean pICECDataBean = pIHSCCECClient.getCECDataBean(stringArray);
            stringArray2.addElement(pICECDataBean);
        }
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, stringArray2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        this.m_writeStatus = false;
    }

    private void doPartitionList() throws PIHscClientException {
        String[] stringArray;
        int n;
        Object object;
        int n2;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4 = new String[]{};
        Vector vector = new Vector();
        String[] stringArray5 = new String[]{"name", "lpar_id", "lpar_env", "state", "resource_config", "os_version", "logical_serial_num", "default_profile", "curr_profile", "work_group_id", "shared_proc_pool_util_auth", "power_ctrl_lpar_ids", "boot_mode", "ipl_source", "lpar_keylock", "auto_start"};
        String[] stringArray6 = new String[]{"lpar_type"};
        if (this.m_format != null && this.m_format.length() > 0) {
            stringArray3 = new String[stringArray5.length + stringArray6.length];
            System.arraycopy(stringArray5, 0, stringArray3, 0, stringArray5.length);
            System.arraycopy(stringArray6, 0, stringArray3, stringArray5.length, stringArray6.length);
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray3, stringArray3.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray2 = PICmdOutputUtils.checkKeys(stringArray3, this.m_format, this.m_delimiter);
        } else {
            stringArray2 = stringArray5;
        }
        stringArray3 = this.m_CECClient.getPartitionNames();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<String> vector3 = new Vector<String>();
        for (n2 = 0; n2 < stringArray3.size(); ++n2) {
            object = (String[])stringArray3.elementAt(n2);
            vector3.add(object[0].substring(0, object[0].indexOf("*")));
            vector2.add(object[1]);
        }
        if (this.m_filterCluster != null) {
            HashMap hashMap = this.m_CECClient.getLparsInClusters(this.m_filterCluster);
            if (hashMap != null && hashMap.size() > 0) {
                object = hashMap.values();
                Iterator iterator = object.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    stringArray = (String[])iterator.next();
                    n += stringArray.length;
                }
                stringArray4 = new String[n];
                n = 0;
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    stringArray = (String[])iterator.next();
                    System.arraycopy(stringArray, 0, stringArray4, n, stringArray.length);
                    n += stringArray.length;
                }
            }
        } else if (this.m_filterPartIDs != null) {
            stringArray4 = this.m_filterPartIDs;
        } else if (this.m_filterPartNames != null) {
            stringArray4 = this.m_filterPartNames;
        } else {
            stringArray4 = new String[stringArray3.size()];
            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                object = (String[])stringArray3.elementAt(n2);
                stringArray4[n2] = ((String)object[0]).substring(0, ((String)object[0]).indexOf("*"));
            }
        }
        Vector vector4 = new Vector();
        boolean bl = true;
        if (this.m_filterPartNames != null) {
            bl = false;
        }
        if (this.m_filterPartNames != null || this.m_filterPartIDs != null) {
            boolean bl2 = true;
            if (this.m_filterPartNames != null) {
                for (n = 0; n < stringArray4.length; ++n) {
                    if (vector2.contains(stringArray4[n])) {
                        bl2 = false;
                    }
                    if (bl2) {
                        stringArray = new String[]{stringArray4[n]};
                        throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                    }
                    bl2 = true;
                }
            }
            if (this.m_filterPartIDs != null) {
                for (n = 0; n < stringArray4.length; ++n) {
                    if (vector3.contains(stringArray4[n])) {
                        bl2 = false;
                    }
                    if (bl2) {
                        stringArray = new String[]{stringArray4[n]};
                        throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
                    }
                    bl2 = true;
                }
            }
        }
        vector4 = this.m_CECClient.getLPARDataBeans(stringArray4, bl);
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector4.elements(), stringArray2, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doProfileList() throws PIHscClientException {
        String[] stringArray;
        int n;
        Object var1_1 = null;
        String[] stringArray2 = null;
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"os400_capable", "assign_5250_cpw_percent"});
        stringArray2 = pICECDataBean.isInteractiveHMCManaged() ? new String[]{"name", "lpar_name", "lpar_id", "lpar_env", "all_resources", "min_mem", "desired_mem", "max_mem", "proc_mode", "min_proc_units", "desired_proc_units", "max_proc_units", "min_procs", "desired_procs", "max_procs", "sharing_mode", "uncap_weight", "min_5250_cpw_percent", "desired_5250_cpw_percent", "max_5250_cpw_percent", "io_slots", "lpar_io_pool_ids", "load_source_slot", "alt_restart_device_slot", "console_slot", "alt_console_slot", "op_console_slot", "max_virtual_slots", "virtual_serial_adapters", "virtual_scsi_adapters", "virtual_eth_adapters", "virtual_opti_pool_id", "hsl_pool_id", "boot_mode", "conn_monitoring", "auto_start", "power_ctrl_lpar_ids", "power_ctrl_lpar_names"} : new String[]{"name", "lpar_name", "lpar_id", "lpar_env", "all_resources", "min_mem", "desired_mem", "max_mem", "proc_mode", "min_proc_units", "desired_proc_units", "max_proc_units", "min_procs", "desired_procs", "max_procs", "sharing_mode", "uncap_weight", "io_slots", "lpar_io_pool_ids", "load_source_slot", "alt_restart_device_slot", "console_slot", "alt_console_slot", "op_console_slot", "max_virtual_slots", "virtual_serial_adapters", "virtual_scsi_adapters", "virtual_eth_adapters", "virtual_opti_pool_id", "hsl_pool_id", "boot_mode", "conn_monitoring", "auto_start", "power_ctrl_lpar_ids", "power_ctrl_lpar_names"};
        String[] stringArray3 = new String[]{"os_type"};
        boolean bl = false;
        String string = null;
        if (this.m_filterPartNames != null) {
            string = this.m_filterPartNames[0];
        } else {
            string = this.m_filterPartIDs[0];
            bl = true;
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            int n2 = stringArray2.length;
            n = PILPARProfileDataBean.MM_KEYS.length;
            String[] stringArray4 = new String[n2 + n + stringArray3.length];
            System.arraycopy(stringArray2, 0, stringArray4, 0, n2);
            System.arraycopy(PILPARProfileDataBean.MM_KEYS, 0, stringArray4, n2, n);
            System.arraycopy(stringArray3, 0, stringArray4, n2 + n, stringArray3.length);
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray4, stringArray4.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray4, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<String> vector = new Vector<String>();
        if (this.m_filterProfs != null) {
            for (n = 0; n < this.m_filterProfs.length; ++n) {
                vector.add(this.m_filterProfs[n]);
            }
        }
        Vector vector2 = new Vector();
        vector2 = this.m_CECClient.getLPARProfileDataBeans(string, bl, vector);
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doSysProfList() throws PIHscClientException {
        String[] stringArray;
        Vector<PIHSCSysProfClient> vector = new Vector<PIHSCSysProfClient>();
        if (this.m_filterProfs == null) {
            stringArray = this.m_CECClient.getSysProfNames();
            for (int i = 0; i < stringArray.size(); ++i) {
                PIHSCSysProfClient pIHSCSysProfClient = this.m_factory.createSysProfClient(this.m_CECClient, (String)stringArray.get(i));
                if (pIHSCSysProfClient == null) continue;
                vector.add(pIHSCSysProfClient);
            }
        } else {
            for (int i = 0; i < this.m_filterProfs.length; ++i) {
                PIHSCSysProfClient pIHSCSysProfClient = this.m_factory.createSysProfClient(this.m_CECClient, this.m_filterProfs[i]);
                if (pIHSCSysProfClient == null) {
                    String[] stringArray2 = new String[]{this.m_filterProfs[i]};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8010", stringArray2, null);
                }
                vector.add(pIHSCSysProfClient);
            }
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PISysProfDataBean.ALL_KEYS, PISysProfDataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PISysProfDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PISysProfDataBean.ALL_KEYS;
        }
        Vector<PISysProfDataBean> vector2 = new Vector<PISysProfDataBean>();
        for (int i = 0; i < vector.size(); ++i) {
            PISysProfDataBean pISysProfDataBean = ((PIHSCSysProfClient)vector.get(i)).getSysProfDataBean(stringArray);
            vector2.addElement(pISysProfDataBean);
        }
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        if ("lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType) || "sysprof".equals(this.m_resourceType)) {
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
            int n = pICECDataBean.getCecState().intValue();
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
            if (n == 251 || n == 253) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
            }
        }
        try {
            this.m_theHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(this.m_theHostName, null);
        if ("sys".equals(this.m_resourceType)) {
            this.doSystemList();
        } else if ("lpar".equals(this.m_resourceType)) {
            this.doPartitionList();
        } else if ("prof".equals(this.m_resourceType)) {
            this.doProfileList();
        } else if ("frame".equals(this.m_resourceType)) {
            this.doFrameList();
        } else if ("cage".equals(this.m_resourceType)) {
            this.doCageList();
        } else {
            this.doSysProfList();
        }
    }

    private void parseFilter(String string) throws PIHscClientException {
        CSVRecord cSVRecord = new CSVRecord(string, true, ",");
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.length() == 0 || string4.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            if ("lpar_names".equals(string3)) {
                if ("sysprof".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{string3, this.m_resourceType};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", stringArray, null);
                }
                this.m_filterPartNames = PIHMCCommandUtils.parseList(string4, ",");
                if (!"prof".equals(this.m_resourceType) || this.m_filterPartNames.length <= 1) continue;
                String[] stringArray = new String[]{string3, this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_TOO_MANY_PARTITIONS", stringArray, null);
            }
            if ("lpar_ids".equals(string3)) {
                if ("sysprof".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{string3, this.m_resourceType};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", stringArray, null);
                }
                this.m_filterPartIDs = PIHMCCommandUtils.parseList(string4, ",");
                if (!"prof".equals(this.m_resourceType) || this.m_filterPartIDs.length <= 1) continue;
                String[] stringArray = new String[]{string3, this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_TOO_MANY_PARTITIONS", stringArray, null);
            }
            if ("profile_names".equals(string3)) {
                if ("lpar".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{string3, this.m_resourceType};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", stringArray, null);
                }
                this.m_filterProfs = PIHMCCommandUtils.parseList(string4, ",");
                continue;
            }
            if ("work_groups".equals(string3)) {
                if (!"lpar".equals(this.m_resourceType)) {
                    String[] stringArray = new String[]{string3, this.m_resourceType};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", stringArray, null);
                }
                this.m_filterCluster = PIHMCCommandUtils.parseList(string4, ",");
                continue;
            }
            String[] stringArray = new String[]{string3};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_NAME", stringArray, null);
        }
        if (this.m_filterPartNames != null && this.m_filterPartIDs != null) {
            String[] stringArray = new String[]{"lpar_names, lpar_ids"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_FILTER_NAMES", stringArray, null);
        }
        if (this.m_filterCluster != null) {
            String[] stringArray = null;
            if (this.m_filterPartNames != null) {
                stringArray = new String[]{"lpar_names, work_groups"};
            } else if (this.m_filterPartIDs != null) {
                stringArray = new String[]{"lpar_ids, work_groups"};
            }
            if (stringArray != null) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_FILTER_NAMES", stringArray, null);
            }
        }
    }

    private void checkParameters() throws PIHscClientException {
        if (!(this.m_resourceType != null && ("sys".equals(this.m_resourceType) || "lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType) || "cage".equals(this.m_resourceType) || "sysprof".equals(this.m_resourceType) || "frame".equals(this.m_resourceType)))) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ("frame".equals(this.m_resourceType) || "cage".equals(this.m_resourceType)) {
            if (this.m_managedSystem != null) {
                String[] stringArray = new String[]{"-m", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
            if ("cage".equals(this.m_resourceType) && (this.m_frame == null || this.m_frame.length() == 0)) {
                String[] stringArray = new String[]{"-e"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else {
            if (this.m_frame != null) {
                String[] stringArray = new String[]{"-e", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
            if (!("sys".equals(this.m_resourceType) || this.m_managedSystem != null && this.m_managedSystem.length() != 0)) {
                String[] stringArray = new String[]{"-m"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        }
        if ("sys".equals(this.m_resourceType) || "cage".equals(this.m_resourceType) || "frame".equals(this.m_resourceType)) {
            String string = "";
            if (this.m_filter != null) {
                String[] stringArray = new String[]{"--filter", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
        }
        if (this.m_filter != null && this.m_filter.length() == 0) {
            String[] stringArray = new String[]{"--filter"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_filter != null) {
            this.parseFilter(this.m_filter);
        }
        if ("prof".equals(this.m_resourceType) && this.m_filterPartNames == null && this.m_filterPartIDs == null) {
            String[] stringArray = new String[]{"--filter"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
        this.m_filter = (String)hashMap.get("--filter");
        this.m_frame = (String)hashMap.get("-e");
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        String string = (String)hashMap.get("-p");
        if (string != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSSYSCFG_P_PARM", null, null);
        }
        String string2 = (String)hashMap.get("--all");
        if (string2 != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSSYSCFG_ALL_PARM", null, null);
        }
        String string3 = (String)hashMap.get("-n");
        if (string3 != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSSYSCFG_N_PARM", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSSYSCFG_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemConfigurationList pISystemConfigurationList = new PISystemConfigurationList(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemConfigurationList.m_validParms);
            pISystemConfigurationList.mapParameters(hashMap);
            pISystemConfigurationList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

